/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.data;

import com.andavin.images.data.DataManager;
import com.andavin.images.image.CustomImage;
import com.andavin.reflect.exception.UncheckedClassNotFoundException;
import com.andavin.util.Logger;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

abstract class SQLDataManager
implements DataManager {
    static final String TABLE_NAME = "`custom_images`";
    private final String url;
    private final Properties properties = new Properties();

    SQLDataManager(String url) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
    }

    SQLDataManager(String url, String user, String password) {
        this(url);
        this.properties.put("user", Preconditions.checkNotNull((Object)user, (Object)"user"));
        this.properties.put("password", Preconditions.checkNotNull((Object)password, (Object)"password"));
    }

    @Override
    public List<CustomImage> load() {
        ArrayList<CustomImage> images = new ArrayList<CustomImage>();
        try (Connection connection = this.getConnection();
             PreparedStatement select = connection.prepareStatement("SELECT `id`, `data` FROM `custom_images`");
             ResultSet result = select.executeQuery();){
            while (result.next()) {
                CustomImage image = this.toImage(result.getBytes("data"));
                image.setId(result.getInt("id"));
                images.add(image);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return images;
    }

    @Override
    public void save(CustomImage image) {
        try (Connection connection = this.getConnection();){
            this.save(connection, image);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveAll(List<CustomImage> images) {
        if (images.isEmpty()) {
            return;
        }
        try (Connection connection = this.getConnection();){
            for (CustomImage image : images) {
                this.save(connection, image);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(CustomImage image) {
        Preconditions.checkState((image.getId() != -1 ? 1 : 0) != 0, (Object)"attempted to delete an image with no database ID");
        try (Connection connection = this.getConnection();
             PreparedStatement delete = connection.prepareStatement("DELETE FROM `custom_images` WHERE `id` = ?");){
            delete.setInt(1, image.getId());
            delete.executeUpdate();
        }
        catch (SQLException e) {
            Logger.severe(e);
        }
    }

    Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.properties);
    }

    private synchronized void save(Connection connection, CustomImage image) throws SQLException {
        if (image.getId() == -1) {
            try (PreparedStatement insert = connection.prepareStatement("INSERT INTO `custom_images`(`data`) VALUES (?)", 1);){
                insert.setObject(1, this.toByteArray(image));
                insert.executeUpdate();
                try (ResultSet result = insert.getGeneratedKeys();){
                    if (result.next()) {
                        image.setId(result.getInt(1));
                    }
                }
            }
            return;
        }
        try (PreparedStatement update = connection.prepareStatement("UPDATE `custom_images` SET `data` = ? WHERE `id` = ?");){
            update.setBytes(1, this.toByteArray(image));
            update.setInt(2, image.getId());
            update.executeUpdate();
        }
    }

    private CustomImage toImage(byte[] bytes) {
        CustomImage customImage;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream stream = new ObjectInputStream(byteStream);
        try {
            customImage = (CustomImage)stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedClassNotFoundException(e.getMessage(), e);
            }
        }
        stream.close();
        return customImage;
    }

    private byte[] toByteArray(CustomImage image) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(byteStream);){
            stream.writeObject(image);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return byteStream.toByteArray();
    }
}

